"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fastifyApollo = void 0;
const fastify_plugin_1 = require("fastify-plugin");
const handler_js_1 = require("./handler.js");
const utils_js_1 = require("./utils.js");
const pluginMetadata = {
    fastify: "^4.4.0",
    name: "@as-integrations/fastify",
};
function fastifyApollo(apollo) {
    if (apollo === undefined || apollo === null || !(0, utils_js_1.isApolloServerLike)(apollo)) {
        throw new TypeError("You must pass in an instance of `ApolloServer`.");
    }
    apollo.assertStarted("fastifyApollo()");
    return (0, fastify_plugin_1.fastifyPlugin)(async (fastify, options) => {
        const { path = "/graphql", method = ["GET", "POST", "OPTIONS"], ...handlerOptions } = options;
        fastify.route({
            method,
            url: path,
            handler: (0, handler_js_1.fastifyApolloHandler)(apollo, handlerOptions),
        });
    }, pluginMetadata);
}
exports.fastifyApollo = fastifyApollo;
