export function fastifyApolloDrainPlugin(fastify) {
    return {
        async serverWillStart() {
            return {
                async drainServer() {
                    if ("closeAllConnections" in fastify.server) {
                        const timeout = setTimeout(() => {
                            fastify.server.closeAllConnections();
                        }, 10_000);
                        await fastify.close();
                        clearTimeout(timeout);
                    }
                },
            };
        },
    };
}
