import { HeaderMap } from "@apollo/server";
const httpHeadersToMap = (headers) => {
    const map = new HeaderMap();
    for (const [key, value] of Object.entries(headers)) {
        if (value) {
            map.set(key, Array.isArray(value) ? value.join(", ") : value);
        }
    }
    return map;
};
export const fastifyRequestToGraphQLRequest = (request) => ({
    body: request.body,
    method: request.method.toUpperCase(),
    headers: httpHeadersToMap(request.headers),
    search: new URL(request.url, `${request.protocol}://${request.hostname}/`).search,
});
