import { ApolloServer, BaseContext } from "@apollo/server";
import type { WithRequired } from "@apollo/utils.withrequired";
import type { ContextConfigDefault, FastifyBaseLogger, FastifySchema, FastifyTypeProvider, FastifyTypeProviderDefault, RawReplyDefaultExpression, RawRequestDefaultExpression, RawServerBase, RawServerDefault, RouteGenericInterface, RouteHandlerMethod } from "fastify";
import { ApolloFastifyHandlerOptions } from "./types.js";
interface RouteInterface extends RouteGenericInterface {
    Reply: string;
}
export declare function fastifyApolloHandler<RawServer extends RawServerBase = RawServerDefault, RawRequest extends RawRequestDefaultExpression<RawServer> = RawRequestDefaultExpression<RawServer>, RawReply extends RawReplyDefaultExpression<RawServer> = RawReplyDefaultExpression<RawServer>, ContextConfig = ContextConfigDefault, SchemaCompiler extends FastifySchema = FastifySchema, TypeProvider extends FastifyTypeProvider = FastifyTypeProviderDefault, Logger extends FastifyBaseLogger = FastifyBaseLogger>(apollo: ApolloServer<BaseContext>): RouteHandlerMethod<RawServer, RawRequest, RawReply, RouteInterface, ContextConfig, SchemaCompiler, TypeProvider, Logger>;
export declare function fastifyApolloHandler<Context extends BaseContext, RawServer extends RawServerBase = RawServerDefault, RawRequest extends RawRequestDefaultExpression<RawServer> = RawRequestDefaultExpression<RawServer>, RawReply extends RawReplyDefaultExpression<RawServer> = RawReplyDefaultExpression<RawServer>, ContextConfig = ContextConfigDefault, SchemaCompiler extends FastifySchema = FastifySchema, TypeProvider extends FastifyTypeProvider = FastifyTypeProviderDefault, Logger extends FastifyBaseLogger = FastifyBaseLogger>(apollo: ApolloServer<Context>, options: WithRequired<ApolloFastifyHandlerOptions<Context, RawServer>, "context">): RouteHandlerMethod<RawServer, RawRequest, RawReply, RouteInterface, ContextConfig, SchemaCompiler, TypeProvider, Logger>;
export {};
