import { Readable } from "node:stream";
import { fastifyRequestToGraphQLRequest } from "./fastify-request-to-graphql-request.js";
import { isApolloServerLike } from "./utils.js";
export function fastifyApolloHandler(apollo, options) {
    if (apollo === undefined || apollo === null || !isApolloServerLike(apollo)) {
        throw new TypeError("You must pass in an instance of `ApolloServer`.");
    }
    apollo.assertStarted("fastifyApolloHandler()");
    const defaultContext = () => Promise.resolve({});
    const contextFunction = options?.context ?? defaultContext;
    return async (request, reply) => {
        const httpGraphQLResponse = await apollo.executeHTTPGraphQLRequest({
            httpGraphQLRequest: fastifyRequestToGraphQLRequest(request),
            context: () => contextFunction(request, reply),
        });
        const { headers, body, status } = httpGraphQLResponse;
        for (const [headerKey, headerValue] of headers) {
            void reply.header(headerKey, headerValue);
        }
        void reply.code(status === undefined ? 200 : status);
        if (body.kind === "complete") {
            return body.string;
        }
        const readable = Readable.from(body.asyncIterator);
        return reply.send(readable);
    };
}
