import { ApolloServer, BaseContext } from "@apollo/server";
import type { WithRequired } from "@apollo/utils.withrequired";
import type { FastifyPluginAsync, FastifyTypeProvider, FastifyTypeProviderDefault, RawServerBase, RawServerDefault } from "fastify";
import { ApolloFastifyPluginOptions } from "./types.js";
export declare function fastifyApollo<RawServer extends RawServerBase = RawServerDefault, TypeProvider extends FastifyTypeProvider = FastifyTypeProviderDefault>(apollo: ApolloServer<BaseContext>): FastifyPluginAsync<Omit<ApolloFastifyPluginOptions<BaseContext, RawServer>, "context">, RawServer, TypeProvider>;
export declare function fastifyApollo<Context extends BaseContext = BaseContext, RawServer extends RawServerBase = RawServerDefault, TypeProvider extends FastifyTypeProvider = FastifyTypeProviderDefault>(apollo: ApolloServer<Context>): FastifyPluginAsync<WithRequired<ApolloFastifyPluginOptions<Context, RawServer>, "context">, RawServer, TypeProvider>;
