import { fastifyPlugin } from "fastify-plugin";
import { fastifyApolloHandler } from "./handler.js";
import { isApolloServerLike } from "./utils.js";
const pluginMetadata = {
    fastify: "^4.4.0",
    name: "@as-integrations/fastify",
};
export function fastifyApollo(apollo) {
    if (apollo === undefined || apollo === null || !isApolloServerLike(apollo)) {
        throw new TypeError("You must pass in an instance of `ApolloServer`.");
    }
    apollo.assertStarted("fastifyApollo()");
    return fastifyPlugin(async (fastify, options) => {
        const { path = "/graphql", method = ["GET", "POST", "OPTIONS"], ...handlerOptions } = options;
        fastify.route({
            method,
            url: path,
            handler: fastifyApolloHandler(apollo, handlerOptions),
        });
    }, pluginMetadata);
}
