"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAsyncIterator = void 0;
/* eslint-disable @typescript-eslint/no-floating-promises */
/* eslint-disable @typescript-eslint/prefer-promise-reject-errors */
const iterall_1 = require("iterall");
const createAsyncIterator = async (lazyFactory, filterFn) => {
    const asyncIterator = await lazyFactory;
    const getNextValue = () => {
        return new Promise((resolve, reject) => {
            const inner = () => {
                if (!asyncIterator || typeof asyncIterator.next !== 'function') {
                    reject(asyncIterator);
                    return;
                }
                asyncIterator
                    .next()
                    .then((payload) => {
                    if (payload.done === true) {
                        resolve(payload);
                        return;
                    }
                    Promise.resolve(filterFn(payload.value))
                        .catch(() => false)
                        .then((result) => {
                        if (result === true) {
                            resolve(payload);
                            return;
                        }
                        inner();
                        return;
                    });
                })
                    .catch(reject);
            };
            inner();
        });
    };
    return {
        next() {
            return getNextValue();
        },
        return() {
            const isAsyncIterator = asyncIterator && typeof asyncIterator.return === 'function';
            return isAsyncIterator
                ? asyncIterator.return()
                : Promise.resolve({
                    done: true,
                    value: asyncIterator,
                });
        },
        throw(error) {
            return asyncIterator.throw(error);
        },
        [iterall_1.$$asyncIterator]() {
            return this;
        },
    };
};
exports.createAsyncIterator = createAsyncIterator;
