import { GraphQLSchema } from 'graphql';
import { GraphQLSchemaBuilder } from '../graphql-schema.builder';
import { AutoSchemaFileValue, BuildFederatedSchemaOptions, GqlModuleOptions } from '../interfaces';
import { ResolversExplorerService, ScalarsExplorerService } from '../services';
import { TypeDefsDecoratorFactory } from './type-defs-decorator.factory';
/**
 * @publicApi
 */
export declare class GraphQLFederationFactory {
    private readonly resolversExplorerService;
    private readonly scalarsExplorerService;
    private readonly gqlSchemaBuilder;
    private readonly typeDefsDecoratorFactory;
    constructor(resolversExplorerService: ResolversExplorerService, scalarsExplorerService: ScalarsExplorerService, gqlSchemaBuilder: GraphQLSchemaBuilder, typeDefsDecoratorFactory: TypeDefsDecoratorFactory);
    generateSchema<T extends GqlModuleOptions>(options?: T, buildFederatedSchema?: (options: BuildFederatedSchemaOptions) => GraphQLSchema): Promise<GraphQLSchema>;
    private buildSchemaFromTypeDefs;
    private generateSchemaFromCodeFirst;
    private getResolvers;
    private extendResolvers;
    private overrideOrExtendResolvers;
    /**
     * Ensures that the resolveType method for unions and interfaces in the federated schema
     * is properly set from the one in the autoGeneratedSchema.
     */
    private overrideFederatedResolveType;
    buildFederatedSchema<T extends GqlModuleOptions>(autoSchemaFile: AutoSchemaFileValue, options: T, resolvers: Function[]): Promise<GraphQLSchema>;
    private getFederationVersionAndConfig;
    private loadFederationDirectives;
}
//# sourceMappingURL=graphql-federation.factory.d.ts.map