"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeTempField = removeTempField;
/**
 * Removes "temp__" field from schema added
 * because of "merge-graphql-schemas" library issues.
 **/
function removeTempField(schema) {
    const queryTypeRef = schema.getQueryType();
    if (!queryTypeRef) {
        return schema;
    }
    const fields = queryTypeRef.getFields();
    if (!fields) {
        return schema;
    }
    delete fields['temp__'];
    return schema;
}
