"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.doubleCsrf = void 0;
const crypto_1 = require("crypto");
const http_errors_1 = __importDefault(require("http-errors"));
function doubleCsrf({ getSecret, getSessionIdentifier = () => "", cookieName = "__Host-psifi.x-csrf-token", cookieOptions: { sameSite = "lax", path = "/", secure = true, httpOnly = true, ...remainingCookieOptions } = {}, delimiter = "|", size = 64, ignoredMethods = ["GET", "HEAD", "OPTIONS"], getTokenFromRequest = (req) => req.headers["x-csrf-token"], errorConfig: { statusCode = 403, message = "invalid csrf token", code = "EBADCSRFTOKEN", } = {}, }) {
    const ignoredMethodsSet = new Set(ignoredMethods);
    const cookieOptions = {
        sameSite,
        path,
        secure,
        httpOnly,
        ...remainingCookieOptions,
    };
    const invalidCsrfTokenError = (0, http_errors_1.default)(statusCode, message, {
        code: code,
    });
    const generateTokenAndHash = (req, overwrite, validateOnReuse) => {
        const getSecretResult = getSecret(req);
        const possibleSecrets = Array.isArray(getSecretResult)
            ? getSecretResult
            : [getSecretResult];
        const csrfCookie = getCsrfCookieFromRequest(req);
        if (typeof csrfCookie === "string" && !overwrite) {
            const [csrfToken, csrfTokenHash] = csrfCookie.split(delimiter);
            if (validateTokenAndHashPair({
                csrfToken,
                csrfTokenHash,
                possibleSecrets,
                sessionIdentifier: getSessionIdentifier(req),
            })) {
                return { csrfToken, csrfTokenHash };
            }
            else if (validateOnReuse) {
                throw invalidCsrfTokenError;
            }
        }
        const csrfToken = (0, crypto_1.randomBytes)(size).toString("hex");
        const secret = possibleSecrets[0];
        const csrfTokenHash = (0, crypto_1.createHash)("sha256")
            .update(`${getSessionIdentifier(req)}${csrfToken}${secret}`)
            .digest("hex");
        return { csrfToken, csrfTokenHash };
    };
    const generateToken = (req, res, overwrite = false, validateOnReuse = true) => {
        const { csrfToken, csrfTokenHash } = generateTokenAndHash(req, overwrite, validateOnReuse);
        const cookieContent = `${csrfToken}${delimiter}${csrfTokenHash}`;
        res.cookie(cookieName, cookieContent, { ...cookieOptions });
        return csrfToken;
    };
    const getCsrfCookieFromRequest = remainingCookieOptions.signed
        ? (req) => req.signedCookies[cookieName]
        : (req) => req.cookies[cookieName];
    const validateTokenAndHashPair = ({ csrfToken, csrfTokenHash, possibleSecrets, sessionIdentifier, }) => {
        if (typeof csrfToken !== "string" || typeof csrfTokenHash !== "string")
            return false;
        for (const secret of possibleSecrets) {
            const expectedHash = (0, crypto_1.createHash)("sha256")
                .update(`${sessionIdentifier}${csrfToken}${secret}`)
                .digest("hex");
            if (csrfTokenHash === expectedHash)
                return true;
        }
        return false;
    };
    const validateRequest = (req) => {
        const csrfCookie = getCsrfCookieFromRequest(req);
        if (typeof csrfCookie !== "string")
            return false;
        const [csrfToken, csrfTokenHash] = csrfCookie.split(delimiter);
        const csrfTokenFromRequest = getTokenFromRequest(req);
        const getSecretResult = getSecret(req);
        const possibleSecrets = Array.isArray(getSecretResult)
            ? getSecretResult
            : [getSecretResult];
        return (csrfToken === csrfTokenFromRequest &&
            validateTokenAndHashPair({
                csrfToken: csrfTokenFromRequest,
                csrfTokenHash,
                possibleSecrets,
                sessionIdentifier: getSessionIdentifier(req),
            }));
    };
    const doubleCsrfProtection = (req, res, next) => {
        req.csrfToken = (overwrite, validateOnReuse) => generateToken(req, res, overwrite, validateOnReuse);
        if (ignoredMethodsSet.has(req.method)) {
            next();
        }
        else if (validateRequest(req)) {
            next();
        }
        else {
            next(invalidCsrfTokenError);
        }
    };
    return {
        invalidCsrfTokenError,
        generateToken,
        validateRequest,
        doubleCsrfProtection,
    };
}
exports.doubleCsrf = doubleCsrf;
